<?php
/*************************************************************************************/
/* registering courses post type.* /
/**************************************************************************************/
add_action( 'init', 'create_post_types_courses' );

function create_post_types_courses() {
    register_post_type( 'courses', array(
            'labels'              => array(
                'name'               => __( ' البرامج التدريبية', 'm7md' ),
                'singular_name'      => __( ' البرامج التدريبية', 'm7md' ),
                'add_new'            => __( 'إضافة برنامج تدريبي', 'm7md' ),
                'add_new_item'       => __( 'برنامج تدريبي جديد', 'm7md' ),
                'all_items'          => __( ' البرامج التدريبية', 'm7md' ),
                'edit_item'          => __( 'تحرير برنامج تدريبي', 'm7md' ),
                'new_item'           => __( 'برنامج تدريبي جديد', 'm7md' ),
                'view_item'          => __( 'معاينة برنامج تدريبي', 'm7md' ),
                'search_items'       => __( 'البحث عن برنامج تدريبي', 'm7md' ),
                'not_found'          => __( 'لا يوجد برنامج تدريبي', 'm7md' ),
                'not_found_in_trash' => __( 'لا يوجد برنامج تدريبي', 'm7md' ),
                'parent_item_colon'  => ''
            ),
            'menu_icon'           => 'dashicons-text-page',
            'hierarchical'        => true,
            'public'              => true,
            'has_archive'         => true,
            'exclude_from_search' => false,
            'menu_position'       => 8,
            'supports'            => array(
                'thumbnail',
                'title',
                'editor',
                'tags',
                'author'
            ),
            'query_var'           => true,
            'rewrite'             => array( 'slug' => 'courses' ),
        )
    );
}



// hook into the init action and call create_courses_taxonomies when it fires
add_action( 'init', 'create_courses_taxonomies', 0 );
// create two taxonomies, genres and writers for the post type "prints"
function create_courses_taxonomies() {
    // Add new taxonomy, make it hierarchical (like categories)
    $labels = array(
        'name'              => __( 'أقسام البرامج التدريبية', 'm7md' ),
        'all_items'         => __( 'كافة الأقسام', 'm7md' ),
    );

    $args = array(
        'hierarchical'        => true,
        'labels'            => $labels,
        'show_ui'           => true,
        'show_admin_column' => true,
        'query_var'         => true,
        'rewrite'           => array( 'slug' => 'course' ),
    );

    register_taxonomy( 'courses_taxonomy', array( 'courses' ), $args );
}
